/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortEnumerator;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    boolean owned;
    String owner;
    boolean inOpen;
    Vector listeners;
    private int portType;
    CommPortIdentifier next;
    private CommPort port;
    private CommDriver driver;
    static CommPortIdentifier masterIdList;
    static Object lock;
    static String propfilename;
    String name;

    private static String[] parsePropsFile(InputStream inputStream) {
        int n;
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            int n2;
            objectArray = new byte[4096];
            n = 0;
            boolean bl = false;
            block7: while ((n2 = inputStream.read()) != -1) {
                switch (n2) {
                    case 10: 
                    case 13: {
                        String string;
                        if (n > 0) {
                            string = new String((byte[])objectArray, 0, n);
                            vector.addElement(string);
                        }
                        n = 0;
                        bl = false;
                        break;
                    }
                    case 35: {
                        String string;
                        bl = true;
                        if (n > 0) {
                            string = new String((byte[])objectArray, 0, n);
                            vector.addElement(string);
                        }
                        n = 0;
                        break;
                    }
                    default: {
                        if (bl || n >= 4096) continue block7;
                        objectArray[n++] = (byte)n2;
                    }
                    case 9: 
                    case 32: 
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Caught " + throwable + " parsing prop file.");
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                objectArray[n] = (byte)((String)vector.elementAt(n));
                ++n;
            }
            return objectArray;
        }
        return null;
    }

    private static void loadDriver(String string) throws IOException {
        File file = new File(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        String[] stringArray = CommPortIdentifier.parsePropsFile(bufferedInputStream);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].regionMatches(true, 0, "driver=", 0, 7)) {
                    String string2 = stringArray[n].substring(7);
                    string2.trim();
                    try {
                        CommDriver commDriver = (CommDriver)Class.forName(string2).newInstance();
                        commDriver.initialize();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Caught " + throwable + " while loading driver " + string2);
                    }
                }
                ++n;
            }
        }
    }

    private static String findPropFile() {
        String string = System.getProperty("java.class.path");
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.whitespaceChars(File.pathSeparatorChar, File.pathSeparatorChar);
        streamTokenizer.wordChars(File.separatorChar, File.separatorChar);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.wordChars(46, 46);
        try {
            while (streamTokenizer.nextToken() != -1) {
                String string2;
                File file;
                int n = -1;
                if (streamTokenizer.ttype != -3 || (n = streamTokenizer.sval.indexOf("comm.jar")) == -1 || !(file = new File(string2 = new String(streamTokenizer.sval))).exists()) continue;
                String string3 = string2.substring(0, n);
                string3 = string3 != null ? String.valueOf(string3) + "." + File.separator + "javax.comm.properties" : "." + File.separator + "javax.comm.properties";
                file = new File(string3);
                if (file.exists()) {
                    return new String(string3);
                }
                return null;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    CommPortIdentifier(String string, CommPort commPort, int n, CommDriver commDriver) {
        this.name = string;
        this.port = commPort;
        this.portType = n;
        this.next = null;
        this.driver = commDriver;
    }

    public static Enumeration getPortIdentifiers() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        return new CommPortEnumerator();
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        Object object = lock;
        synchronized (object) {
            commPortIdentifier = masterIdList;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.name.equals(string)) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        Object object = lock;
        synchronized (object) {
            commPortIdentifier = masterIdList;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.port == commPort) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    private static void addPort(CommPort commPort, int n) {
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(commPort.getName(), commPort, n, null);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
            return;
        }
    }

    private static void addPort(String string, int n) {
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(string, null, n, null);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
            return;
        }
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(string, null, n, commDriver);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPortType() {
        return this.portType;
    }

    public String getCurrentOwner() {
        return this.owner;
    }

    public synchronized boolean isCurrentlyOwned() {
        return this.owned;
    }

    public synchronized CommPort open(String string, int n) throws PortInUseException {
        try {
            while (this.owned) {
                this.inOpen = true;
                this.fireOwnershipEvent(3);
                this.wait(n);
                if (!this.owned) continue;
                this.inOpen = false;
                throw new PortInUseException(this.getCurrentOwner());
            }
            this.inOpen = false;
        }
        catch (InterruptedException interruptedException) {
            this.inOpen = false;
            return null;
        }
        if (this.port == null) {
            this.port = this.driver.getCommPort(this.name, this.portType);
        }
        if (this.port == null) {
            throw new PortInUseException("unknown Solaris Application");
        }
        this.fireOwnershipEvent(1);
        this.owned = true;
        this.owner = string;
        return this.port;
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    synchronized void internalClosePort() {
        this.port = null;
        this.owned = false;
        this.owner = null;
        this.notifyAll();
        if (!this.inOpen) {
            this.fireOwnershipEvent(2);
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1, 1);
        }
        if (!this.listeners.contains(commPortOwnershipListener)) {
            this.listeners.addElement(commPortOwnershipListener);
        }
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(commPortOwnershipListener);
        }
    }

    void fireOwnershipEvent(int n) {
        if (this.listeners != null) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                CommPortOwnershipListener commPortOwnershipListener = (CommPortOwnershipListener)enumeration.nextElement();
                commPortOwnershipListener.ownershipChange(n);
            }
        }
    }

    static {
        lock = new Object();
        String string = System.getProperty("javax.comm.properties");
        if (string != null) {
            System.err.println("Comm Drivers: " + string);
        }
        String string2 = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "javax.comm.properties";
        try {
            CommPortIdentifier.loadDriver(string2);
            propfilename = new String(string2);
            return;
        }
        catch (IOException iOException) {
            propfilename = CommPortIdentifier.findPropFile();
            try {
                if (propfilename != null) {
                    CommPortIdentifier.loadDriver(propfilename);
                    return;
                }
            }
            catch (IOException iOException2) {
                propfilename = new String(" ");
                System.err.println(iOException2);
                return;
            }
            return;
        }
    }
}

