/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.Zystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public final class RXTXPort
extends SerialPort {
    protected static final boolean debug = false;
    protected static final boolean debug_read = false;
    protected static final boolean debug_read_results = false;
    protected static final boolean debug_write = false;
    protected static final boolean debug_events = false;
    protected static final boolean debug_verbose = false;
    private static Zystem z;
    boolean MonitorThreadAlive = false;
    int IOLocked = 0;
    private int fd = 0;
    long eis = 0L;
    int pid = 0;
    static boolean dsrFlag;
    private final SerialOutputStream out = new SerialOutputStream();
    private final SerialInputStream in = new SerialInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private SerialPortEventListener SPEventListener;
    private MonitorThread monThread;
    boolean monThreadisInterrupted = true;
    boolean MonitorThreadLock = true;
    boolean MonitorThreadCloseLock = true;
    boolean closeLock = false;

    private static native void Initialize();

    public RXTXPort(String string) throws PortInUseException {
        this.fd = this.open(string);
        this.name = string;
        this.MonitorThreadLock = true;
        this.monThread = new MonitorThread();
        this.monThread.start();
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadAlive = true;
        this.timeout = -1;
    }

    private synchronized native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    private native int nativeGetParity(int var1);

    private native int nativeGetFlowControlMode(int var1);

    public synchronized void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        if (this.nativeSetSerialPortParams(n, n2, n3, n4)) {
            throw new UnsupportedCommOperationException("Invalid Parameter");
        }
        this.speed = n;
        this.dataBits = n3 == 3 ? 5 : n2;
        this.stopBits = n3;
        this.parity = n4;
        z.reportln("RXTXPort:setSerialPortParams(" + n + " " + n2 + " " + n3 + " " + n4 + ") returning");
    }

    private native boolean nativeSetSerialPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public int getBaudRate() {
        return this.speed;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setFlowControlMode(int n) {
        if (this.monThreadisInterrupted) {
            return;
        }
        try {
            this.setflowcontrol(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.flowmode = n;
    }

    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public native int NativegetReceiveTimeout();

    private native boolean NativeisReceiveTimeoutEnabled();

    private native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    public void disableReceiveTimeout() {
        this.timeout = -1;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
    }

    public void enableReceiveTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative timeout value");
        }
        this.timeout = n;
        this.NativeEnableReceiveTimeoutThreshold(n, this.threshold, this.InputBuffer);
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.NativeisReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() {
        return this.NativegetReceiveTimeout();
    }

    public void enableReceiveThreshold(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative threshold value");
        }
        this.threshold = n;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
    }

    public void disableReceiveThreshold() {
        this.enableReceiveThreshold(0);
    }

    public int getReceiveThreshold() {
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.threshold > 0;
    }

    public void setInputBufferSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.InputBuffer = n;
    }

    public int getInputBufferSize() {
        return this.InputBuffer;
    }

    public void setOutputBufferSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.OutputBuffer = n;
    }

    public int getOutputBufferSize() {
        return this.OutputBuffer;
    }

    public native boolean isDTR();

    public native void setDTR(boolean var1);

    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    public native boolean isCTS();

    public native boolean isDSR();

    public native boolean isCD();

    public native boolean isRI();

    public native boolean isRTS();

    public native void sendBreak(int var1);

    protected native void writeByte(int var1, boolean var2) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected native boolean nativeDrain(boolean var1) throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    protected native int readTerminatedArray(byte[] var1, int var2, int var3, byte[] var4) throws IOException;

    native void eventLoop();

    private native void interruptEventLoop();

    public boolean checkMonitorThread() {
        if (this.monThread != null) {
            return this.monThreadisInterrupted;
        }
        return true;
    }

    public boolean sendEvent(int n, boolean bl) {
        if (this.fd == 0 || this.SPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
        }
        switch (n) {
            case 1: {
                if (this.monThread.Data) break;
                return false;
            }
            case 2: {
                if (this.monThread.Output) break;
                return false;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return false;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return false;
            }
            case 5: {
                if (this.monThread.RI) break;
                return false;
            }
            case 6: {
                if (this.monThread.CD) break;
                return false;
            }
            case 7: {
                if (this.monThread.OE) break;
                return false;
            }
            case 8: {
                if (this.monThread.PE) break;
                return false;
            }
            case 9: {
                if (this.monThread.FE) break;
                return false;
            }
            case 10: {
                if (this.monThread.BI) break;
                return false;
            }
            default: {
                System.err.println("unknown event: " + n);
                return false;
            }
        }
        SerialPortEvent serialPortEvent = new SerialPortEvent((SerialPort)this, n, !bl, bl);
        if (this.monThreadisInterrupted) {
            return true;
        }
        if (this.SPEventListener != null) {
            this.SPEventListener.serialEvent(serialPortEvent);
        }
        return this.fd == 0 || this.SPEventListener == null || this.monThread == null;
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = serialPortEventListener;
        if (!this.MonitorThreadAlive) {
            this.MonitorThreadLock = true;
            this.monThread = new MonitorThread();
            this.monThread.start();
            this.waitForTheNativeCodeSilly();
            this.MonitorThreadAlive = true;
        }
    }

    public void removeEventListener() {
        this.waitForTheNativeCodeSilly();
        if (this.monThreadisInterrupted) {
            z.reportln("\tRXTXPort:removeEventListener() already interrupted");
            this.monThread = null;
            this.SPEventListener = null;
            Runtime.getRuntime().gc();
            return;
        }
        if (this.monThread != null && this.monThread.isAlive()) {
            this.monThreadisInterrupted = true;
            this.MonitorThreadCloseLock = true;
            this.interruptEventLoop();
            while (this.MonitorThreadCloseLock) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            try {
                this.monThread.join(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (this.monThread.isAlive()) {
                try {
                    this.monThread.join(1000L);
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        this.monThread = null;
        this.SPEventListener = null;
        Runtime.getRuntime().gc();
        this.MonitorThreadLock = false;
        this.MonitorThreadAlive = false;
        this.monThreadisInterrupted = true;
        z.reportln("RXTXPort:removeEventListener() returning");
    }

    protected void waitForTheNativeCodeSilly() {
        while (this.MonitorThreadLock) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    private native void nativeSetEventFlag(int var1, int var2, boolean var3);

    public void notifyOnDataAvailable(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 1, bl);
        this.monThread.Data = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOutputEmpty(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 2, bl);
        this.monThread.Output = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCTS(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 3, bl);
        this.monThread.CTS = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnDSR(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 4, bl);
        this.monThread.DSR = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnRingIndicator(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 5, bl);
        this.monThread.RI = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCarrierDetect(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 6, bl);
        this.monThread.CD = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOverrunError(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 7, bl);
        this.monThread.OE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnParityError(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 8, bl);
        this.monThread.PE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnFramingError(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 9, bl);
        this.monThread.FE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 10, bl);
        this.monThread.BI = bl;
        this.MonitorThreadLock = false;
    }

    private native void nativeClose(String var1);

    public synchronized void close() {
        if (this.closeLock) {
            return;
        }
        this.closeLock = true;
        while (this.IOLocked > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        if (this.fd <= 0) {
            z.reportln("RXTXPort:close detected bad File Descriptor");
            return;
        }
        this.setDTR(false);
        this.setDSR(false);
        if (!this.monThreadisInterrupted) {
            this.removeEventListener();
        }
        this.nativeClose(this.name);
        super.close();
        this.fd = 0;
        Runtime.getRuntime().gc();
        this.closeLock = false;
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
        z.finalize();
    }

    public void setRcvFifoTrigger(int n) {
    }

    private static native void nativeStaticSetSerialPortParams(String var0, int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetDSR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetDTR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetRTS(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsDSR(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsDTR(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsRTS(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsCTS(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsCD(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsRI(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetBaudRate(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetDataBits(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetParity(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetStopBits(String var0) throws UnsupportedCommOperationException;

    private native byte nativeGetParityErrorChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetParityErrorChar(byte var1) throws UnsupportedCommOperationException;

    private native byte nativeGetEndOfInputChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetEndOfInputChar(byte var1) throws UnsupportedCommOperationException;

    private native boolean nativeSetUartType(String var1, boolean var2) throws UnsupportedCommOperationException;

    native String nativeGetUartType() throws UnsupportedCommOperationException;

    private native boolean nativeSetBaudBase(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetBaudBase() throws UnsupportedCommOperationException;

    private native boolean nativeSetDivisor(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetDivisor() throws UnsupportedCommOperationException;

    private native boolean nativeSetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeGetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeSetCallOutHangup(boolean var1) throws UnsupportedCommOperationException;

    private native boolean nativeGetCallOutHangup() throws UnsupportedCommOperationException;

    public static int staticGetBaudRate(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticGetBaudRate(string);
    }

    public static int staticGetDataBits(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticGetDataBits(string);
    }

    public static int staticGetParity(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticGetParity(string);
    }

    public static int staticGetStopBits(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticGetStopBits(string);
    }

    public static void staticSetSerialPortParams(String string, int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        RXTXPort.nativeStaticSetSerialPortParams(string, n, n2, n3, n4);
    }

    public static boolean staticSetDSR(String string, boolean bl) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticSetDSR(string, bl);
    }

    public static boolean staticSetDTR(String string, boolean bl) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticSetDTR(string, bl);
    }

    public static boolean staticSetRTS(String string, boolean bl) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticSetRTS(string, bl);
    }

    public static boolean staticIsRTS(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsRTS(string);
    }

    public static boolean staticIsCD(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsCD(string);
    }

    public static boolean staticIsCTS(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsCTS(string);
    }

    public static boolean staticIsDSR(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsDSR(string);
    }

    public static boolean staticIsDTR(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsDTR(string);
    }

    public static boolean staticIsRI(String string) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsRI(string);
    }

    public byte getParityErrorChar() throws UnsupportedCommOperationException {
        byte by = this.nativeGetParityErrorChar();
        return by;
    }

    public boolean setParityErrorChar(byte by) throws UnsupportedCommOperationException {
        return this.nativeSetParityErrorChar(by);
    }

    public byte getEndOfInputChar() throws UnsupportedCommOperationException {
        byte by = this.nativeGetEndOfInputChar();
        return by;
    }

    public boolean setEndOfInputChar(byte by) throws UnsupportedCommOperationException {
        return this.nativeSetEndOfInputChar(by);
    }

    public boolean setUARTType(String string, boolean bl) throws UnsupportedCommOperationException {
        return this.nativeSetUartType(string, bl);
    }

    public String getUARTType() throws UnsupportedCommOperationException {
        return this.nativeGetUartType();
    }

    public boolean setBaudBase(int n) throws UnsupportedCommOperationException {
        return this.nativeSetBaudBase(n);
    }

    public int getBaudBase() throws UnsupportedCommOperationException {
        return this.nativeGetBaudBase();
    }

    public boolean setDivisor(int n) throws UnsupportedCommOperationException {
        return this.nativeSetDivisor(n);
    }

    public int getDivisor() throws UnsupportedCommOperationException {
        return this.nativeGetDivisor();
    }

    public boolean setLowLatency() throws UnsupportedCommOperationException {
        return this.nativeSetLowLatency();
    }

    public boolean getLowLatency() throws UnsupportedCommOperationException {
        return this.nativeGetLowLatency();
    }

    public boolean setCallOutHangup(boolean bl) throws UnsupportedCommOperationException {
        return this.nativeSetCallOutHangup(bl);
    }

    public boolean getCallOutHangup() throws UnsupportedCommOperationException {
        return this.nativeGetCallOutHangup();
    }

    static {
        try {
            z = new Zystem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.loadLibrary("rxtxSerial");
        RXTXPort.Initialize();
        dsrFlag = false;
    }

    class MonitorThread
    extends Thread {
        private volatile boolean CTS = false;
        private volatile boolean DSR = false;
        private volatile boolean RI = false;
        private volatile boolean CD = false;
        private volatile boolean OE = false;
        private volatile boolean PE = false;
        private volatile boolean FE = false;
        private volatile boolean BI = false;
        private volatile boolean Data = false;
        private volatile boolean Output = false;

        MonitorThread() {
        }

        public void run() {
            RXTXPort.this.monThreadisInterrupted = false;
            RXTXPort.this.eventLoop();
            RXTXPort.this.MonitorThreadCloseLock = false;
        }

        protected void finalize() throws Throwable {
        }
    }

    class SerialInputStream
    extends InputStream {
        SerialInputStream() {
        }

        public synchronized int read() throws IOException {
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                z.reportln("+++++++++ read() monThreadisInterrupted");
            }
            ++RXTXPort.this.IOLocked;
            RXTXPort.this.waitForTheNativeCodeSilly();
            int n = RXTXPort.this.readByte();
            --RXTXPort.this.IOLocked;
            return n;
        }

        public synchronized int read(byte[] byArray) throws IOException {
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            ++RXTXPort.this.IOLocked;
            RXTXPort.this.waitForTheNativeCodeSilly();
            int n = this.read(byArray, 0, byArray.length);
            --RXTXPort.this.IOLocked;
            return n;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (RXTXPort.this.fd == 0) {
                z.reportln("+++++++ IOException()\n");
                throw new IOException();
            }
            if (byArray == null) {
                z.reportln("+++++++ NullPointerException()\n");
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                z.reportln("+++++++ IndexOutOfBoundsException()\n");
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n4 = n2;
            n4 = RXTXPort.this.threshold == 0 ? ((n3 = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(n4, n3)) : Math.min(n4, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            ++RXTXPort.this.IOLocked;
            RXTXPort.this.waitForTheNativeCodeSilly();
            int n5 = RXTXPort.this.readArray(byArray, n, n4);
            --RXTXPort.this.IOLocked;
            return n5;
        }

        public synchronized int read(byte[] byArray, int n, int n2, byte[] byArray2) throws IOException {
            int n3;
            if (RXTXPort.this.fd == 0) {
                z.reportln("+++++++ IOException()\n");
                throw new IOException();
            }
            if (byArray == null) {
                z.reportln("+++++++ NullPointerException()\n");
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                z.reportln("+++++++ IndexOutOfBoundsException()\n");
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n4 = n2;
            n4 = RXTXPort.this.threshold == 0 ? ((n3 = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(n4, n3)) : Math.min(n4, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            ++RXTXPort.this.IOLocked;
            RXTXPort.this.waitForTheNativeCodeSilly();
            int n5 = RXTXPort.this.readTerminatedArray(byArray, n, n4, byArray2);
            --RXTXPort.this.IOLocked;
            return n5;
        }

        public synchronized int available() throws IOException {
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            ++RXTXPort.this.IOLocked;
            int n = RXTXPort.this.nativeavailable();
            --RXTXPort.this.IOLocked;
            return n;
        }
    }

    class SerialOutputStream
    extends OutputStream {
        SerialOutputStream() {
        }

        public void write(int n) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            ++RXTXPort.this.IOLocked;
            RXTXPort.this.waitForTheNativeCodeSilly();
            if (RXTXPort.this.fd == 0) {
                --RXTXPort.this.IOLocked;
                throw new IOException();
            }
            RXTXPort.this.writeByte(n, RXTXPort.this.monThreadisInterrupted);
            --RXTXPort.this.IOLocked;
        }

        public void write(byte[] byArray) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            ++RXTXPort.this.IOLocked;
            RXTXPort.this.waitForTheNativeCodeSilly();
            RXTXPort.this.writeArray(byArray, 0, byArray.length, RXTXPort.this.monThreadisInterrupted);
            --RXTXPort.this.IOLocked;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException("Invalid offset/length passed to read");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            ++RXTXPort.this.IOLocked;
            RXTXPort.this.waitForTheNativeCodeSilly();
            RXTXPort.this.writeArray(byArray2, 0, n2, RXTXPort.this.monThreadisInterrupted);
            --RXTXPort.this.IOLocked;
        }

        public void flush() throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            ++RXTXPort.this.IOLocked;
            RXTXPort.this.waitForTheNativeCodeSilly();
            if (RXTXPort.this.nativeDrain(RXTXPort.this.monThreadisInterrupted)) {
                RXTXPort.this.sendEvent(2, true);
            }
            --RXTXPort.this.IOLocked;
        }
    }
}

